package ru.yandex.canvas.service.multitype;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;

import ru.yandex.canvas.model.CreativeWithId;
import ru.yandex.canvas.service.OnCreativeFetchingService;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;

public abstract class SingleCreativeTypeBaseOperation<T extends CreativeWithId,
        R extends SingleCreativeTypeOperationRequest> implements SingleCreativeTypeOperation<R> {
    private OnCreativeFetchingService onCreativeService;
    private Logger logger;

    @Override
    public void init(OnCreativeFetchingService service, Logger logger) {
        this.onCreativeService = service;
        this.logger = logger;
    }

    public Logger getLogger() {
        return logger;
    }

    @Override
    public OnCreativeFetchingService<T> getOnCreativeService() {
        return onCreativeService;
    }

    public void checkAndMergeResults(
            List<T> creatives, List<OnCreativeOperationResult> resultsList, Map<Long, OnCreativeOperationResult> result) {
        int creativesAmount = creatives.size();

        if (creativesAmount != resultsList.size()) {
            throw new IllegalStateException("processCreatives result list not match argument list by size");
        }

        for (int i = 0; i < creativesAmount; i++) {
            Long id = creatives.get(i).fetchCreativeId();
            if (result.containsKey(id)) {
                throw new IllegalStateException("Creative id: " + id + " already exists in result map");
            }
            result.put(id, resultsList.get(i));
        }
    }
}
