package ru.yandex.canvas.service.multitype;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.errorprone.annotations.ForOverride;

import ru.yandex.canvas.model.CreativeWithId;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;

/**
 * @param <T> Тип креатива
 * @param <R> Тип запроса, принимаемого операцией
 */
public abstract class SingleCreativeTypeIdsOperation<T extends CreativeWithId,
        R extends SingleCreativeTypeOperationRequest> extends SingleCreativeTypeBaseOperation<T, R> {
    @ForOverride
    public abstract List<OnCreativeOperationResult> process(List<T> creatives);

    @Override
    public void run(R request, Map<Long, OnCreativeOperationResult> result) {
        List<Long> creativeIds = request.getCreativeIds();
        List<T> creatives = getOnCreativeService().fetchByIds(creativeIds);
        getLogger().info("SingleTypeOperation on " + worksOn() + " fetched ids: {}",
                creatives.stream().map(c -> c.fetchCreativeId()).collect(Collectors.toList()));
        if (creativeIds.size() != creatives.size()) {
            throw new IllegalStateException("Fetched creatives amount not match ids list");
        }
        List<OnCreativeOperationResult> resultsList = process(creatives);
        checkAndMergeResults(creatives, resultsList, result);
    }
}
