package ru.yandex.canvas.service.multitype;

import java.util.Map;

import com.google.errorprone.annotations.ForOverride;
import org.slf4j.Logger;

import ru.yandex.canvas.service.OnCreativeFetchingService;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;

public interface SingleCreativeTypeOperation<T extends SingleCreativeTypeOperationRequest> {
    @ForOverride
    CreativeType worksOn();
    void run(T request, Map<Long, OnCreativeOperationResult> result);
    void init(OnCreativeFetchingService service, Logger logger);
    OnCreativeFetchingService getOnCreativeService();
}
