package ru.yandex.canvas.service.multitype;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация которой отмечается метод возвращающий пару — операция над креативами одного типа (CreativeType) + сервис
 * предоставляющий основные операции для работы с этим типом креативов
 */
@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface SingleCreativeTypeOperationProvider {
    CreativeType value();
}
