package ru.yandex.canvas.service.multitype.operation;

import ru.yandex.canvas.service.html5.Html5CreativesService;
import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.MultiCreativeTypeBaseOperation;
import ru.yandex.canvas.service.multitype.MultiCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.OnCreativeServiceProvider;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperationProvider;
import ru.yandex.canvas.service.multitype.request.DefaultRequest;
import ru.yandex.canvas.service.multitype.singletype.RebuildHtml5Operation;
import ru.yandex.canvas.service.multitype.singletype.RebuildStockVideoOperation;
import ru.yandex.canvas.service.multitype.singletype.RebuildVideoOperation;
import ru.yandex.canvas.service.video.VideoCreativesService;

public class RebuildOperation
        extends MultiCreativeTypeBaseOperation<DefaultRequest>
        implements MultiCreativeTypeOperation<DefaultRequest> {
    private final VideoCreativesService videoCreativesService;
    private final Html5CreativesService html5CreativesService;

    public RebuildOperation(OnCreativeServiceProvider onCreativeServiceProvider,
                            VideoCreativesService videoCreativesService, Html5CreativesService html5CreativesService) {
        super(onCreativeServiceProvider);
        this.videoCreativesService = videoCreativesService;
        this.html5CreativesService = html5CreativesService;
    }

    // AdBuilder - нечего пересобирать

    @SingleCreativeTypeOperationProvider(CreativeType.HTML5)
    public SingleCreativeTypeOperation rebuildHtml5CreativesOperation() {
        return new RebuildHtml5Operation(html5CreativesService);
    }

    /**
     * Какие бывают видео креативы
     * - видео дополнения из стоковых видео дополнения - mongodb.stock_video_additions, mongodb.stock_video_additions
     *      creative_id != stock_creative_id
     * - видео дополнения к текстовым баннерам - mongodb.video_additions creative_id == stock_creative_id
     * - видео креативы (бывают просто видео файлом без элентов управления) - mongodb.video_additions
     * - videomotion (дефолтное видео дополнение) - вообще нигде не хранятся, существует в виде кода в конструкторе и
     *      в транспорте в БК, для перепосылки VAST-а в RtbHost видео моушена
     *      смотри {@link ru.yandex.canvas.controllers.video.VideoMotionController#exportVideoMotionToRtbHost}
     *      сам VAST мы при этом не храним
     *
     * @return
     */
    @SingleCreativeTypeOperationProvider(CreativeType.VIDEO)
    public SingleCreativeTypeOperation rebuildVideoCreativesOpertaion() {
        return new RebuildVideoOperation(videoCreativesService);
    }

    @SingleCreativeTypeOperationProvider(CreativeType.STOCK_VIDEO)
    public SingleCreativeTypeOperation rebuildStockVideoCreativesOpertaion() {
        return new RebuildStockVideoOperation(videoCreativesService);
    }
}
