package ru.yandex.canvas.service.multitype.operation;

import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.MultiCreativeTypeBaseOperation;
import ru.yandex.canvas.service.multitype.MultiCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.OnCreativeServiceProvider;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperationProvider;
import ru.yandex.canvas.service.multitype.request.DefaultRequest;
import ru.yandex.canvas.service.multitype.singletype.ScreenshotAdBuilderOperation;
import ru.yandex.canvas.service.multitype.singletype.ScreenshotHtml5Operation;
import ru.yandex.canvas.service.multitype.singletype.ScreenshotVideoOperation;
import ru.yandex.canvas.service.screenshooters.CreativesScreenshooterHelperService;
import ru.yandex.canvas.service.screenshooters.Html5ScreenshooterHelperService;
import ru.yandex.canvas.service.screenshooters.VideoAdditionScreenshooterHelperService;

public class ScreenshotOperation
        extends MultiCreativeTypeBaseOperation<DefaultRequest>
        implements MultiCreativeTypeOperation<DefaultRequest> {

    private final Html5ScreenshooterHelperService screenshooterHelperService;
    private final CreativesScreenshooterHelperService creativesScreenshooterHelperService;
    private final VideoAdditionScreenshooterHelperService videoAdditionScreenshooterHelperService;

    public ScreenshotOperation(OnCreativeServiceProvider onCreativeServiceProvider,
                               Html5ScreenshooterHelperService screenshooterHelperService,
                               CreativesScreenshooterHelperService creativesScreenshooterHelperService,
                               VideoAdditionScreenshooterHelperService videoAdditionScreenshooterHelperService) {
        super(onCreativeServiceProvider);
        this.screenshooterHelperService = screenshooterHelperService;
        this.creativesScreenshooterHelperService = creativesScreenshooterHelperService;
        this.videoAdditionScreenshooterHelperService = videoAdditionScreenshooterHelperService;
    }

    @SingleCreativeTypeOperationProvider(CreativeType.HTML5)
    public SingleCreativeTypeOperation screenshotHtml5() {
        return new ScreenshotHtml5Operation(screenshooterHelperService);
    }

    @SingleCreativeTypeOperationProvider(CreativeType.AD_BUILDER)
    public SingleCreativeTypeOperation screenshotAdBuilder() {
        return new ScreenshotAdBuilderOperation(creativesScreenshooterHelperService);
    }

    @SingleCreativeTypeOperationProvider(CreativeType.VIDEO)
    public SingleCreativeTypeOperation screenshotVideo() {
        return new ScreenshotVideoOperation(videoAdditionScreenshooterHelperService);
    }

}
