package ru.yandex.canvas.service.multitype.operation;

import ru.yandex.canvas.service.DirectService;
import ru.yandex.canvas.service.direct.CreativeUploadHelperFacade;
import ru.yandex.canvas.service.direct.Html5CreativeDirectUploadHelper;
import ru.yandex.canvas.service.direct.VideoAdditionDirectUploadHelper;
import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.MultiCreativeTypeBaseOperation;
import ru.yandex.canvas.service.multitype.MultiCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.OnCreativeServiceProvider;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperationProvider;
import ru.yandex.canvas.service.multitype.request.DefaultRequest;
import ru.yandex.canvas.service.multitype.singletype.SendToDirectAdBuilderOperation;
import ru.yandex.canvas.service.multitype.singletype.SendToDirectHtml5Operation;
import ru.yandex.canvas.service.multitype.singletype.SendToDirectVideoOperation;

public class SendToDirectOperation
        extends MultiCreativeTypeBaseOperation<DefaultRequest>
        implements MultiCreativeTypeOperation<DefaultRequest> {
    private final Html5CreativeDirectUploadHelper html5CreativesService;
    private final CreativeUploadHelperFacade creativesService;
    private final VideoAdditionDirectUploadHelper videoAdditionDirectUploadHelper;

    private final DirectService directService;

    public SendToDirectOperation(OnCreativeServiceProvider onCreativeServiceProvider,
                                 Html5CreativeDirectUploadHelper html5CreativesService,
                                 CreativeUploadHelperFacade creativesService,
                                 VideoAdditionDirectUploadHelper videoAdditionDirectUploadHelper,
                                 DirectService directService) {
        super(onCreativeServiceProvider);
        this.html5CreativesService = html5CreativesService;
        this.creativesService = creativesService;
        this.videoAdditionDirectUploadHelper = videoAdditionDirectUploadHelper;
        this.directService = directService;
    }

    @SingleCreativeTypeOperationProvider(CreativeType.HTML5)
    public SingleCreativeTypeOperation sendHtml5CreativesToDirect() {
        return new SendToDirectHtml5Operation(html5CreativesService, directService);
    }

    @SingleCreativeTypeOperationProvider(CreativeType.AD_BUILDER)
    public SingleCreativeTypeOperation sendAdBuilderCreativesToDirect() {
        return new SendToDirectAdBuilderOperation(creativesService, directService);
    }

    @SingleCreativeTypeOperationProvider(CreativeType.VIDEO)
    public SingleCreativeTypeOperation sendVideoCreativesToDirect() {
        return new SendToDirectVideoOperation(videoAdditionDirectUploadHelper, directService);
    }
}
