package ru.yandex.canvas.service.multitype.operation;

import ru.yandex.canvas.repository.video.StockVideoAdditionsRepository;
import ru.yandex.canvas.repository.video.VideoAdditionsRepository;
import ru.yandex.canvas.service.RTBHostExportService;
import ru.yandex.canvas.service.html5.Html5SourcesService;
import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.MultiCreativeTypeBaseOperation;
import ru.yandex.canvas.service.multitype.MultiCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.OnCreativeServiceProvider;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperationProvider;
import ru.yandex.canvas.service.multitype.request.DefaultRequest;
import ru.yandex.canvas.service.multitype.singletype.SendToRtbHostAdBuilderCreativeOperation;
import ru.yandex.canvas.service.multitype.singletype.SendToRtbHostHtml5Operation;
import ru.yandex.canvas.service.multitype.singletype.SendToRtbHostStockVideoOperation;
import ru.yandex.canvas.service.multitype.singletype.SendToRtbHostVideoOperation;
import ru.yandex.canvas.service.rtbhost.helpers.CreativesDspUploadFacade;
import ru.yandex.canvas.service.rtbhost.helpers.creative.Html5DspUploadHelper;
import ru.yandex.canvas.service.video.VideoCreativesService;

public class SendToRtbHostOperation
        extends MultiCreativeTypeBaseOperation<DefaultRequest>
        implements MultiCreativeTypeOperation<DefaultRequest> {
    private final CreativesDspUploadFacade creativesService;
    private final VideoCreativesService videoCreativesService;
    private final RTBHostExportService rtbHostExportService;
    private final Html5SourcesService sourcesService;
    private final Html5DspUploadHelper html5DspUploadHelper;
    private final VideoAdditionsRepository videoAdditionsRepository;
    private final StockVideoAdditionsRepository stockVideoAdditionsRepository;

    public SendToRtbHostOperation(OnCreativeServiceProvider onCreativeServiceProvider,
                                  CreativesDspUploadFacade creativesService,
                                  VideoCreativesService videoCreativesService,
                                  RTBHostExportService rtbHostExportService, Html5SourcesService sourcesService,
                                  Html5DspUploadHelper html5DspUploadHelper,
                                  VideoAdditionsRepository videoAdditionsRepository,
                                  StockVideoAdditionsRepository stockVideoAdditionsRepository) {
        super(onCreativeServiceProvider);
        this.creativesService = creativesService;
        this.videoCreativesService = videoCreativesService;
        this.rtbHostExportService = rtbHostExportService;
        this.sourcesService = sourcesService;
        this.html5DspUploadHelper = html5DspUploadHelper;
        this.videoAdditionsRepository = videoAdditionsRepository;
        this.stockVideoAdditionsRepository = stockVideoAdditionsRepository;
    }

    @SingleCreativeTypeOperationProvider(CreativeType.HTML5)
    public SingleCreativeTypeOperation sendHtml5CreativesToRtbHost() {
        return new SendToRtbHostHtml5Operation(html5DspUploadHelper, rtbHostExportService, sourcesService);
    }

    @SingleCreativeTypeOperationProvider(CreativeType.AD_BUILDER)
    public SingleCreativeTypeOperation sendAdBuilderCreativesToRtbHost() {
        return new SendToRtbHostAdBuilderCreativeOperation(creativesService, rtbHostExportService);
    }

    @SingleCreativeTypeOperationProvider(CreativeType.VIDEO)
    public SingleCreativeTypeOperation sendVideoCreativesToRtbHost() {
        return new SendToRtbHostVideoOperation(videoCreativesService, rtbHostExportService, videoAdditionsRepository);
    }

    @SingleCreativeTypeOperationProvider(CreativeType.STOCK_VIDEO)
    public SingleCreativeTypeOperation sendStockVideoCreativesToRtbHost() {
        return new SendToRtbHostStockVideoOperation(videoCreativesService, rtbHostExportService,
                stockVideoAdditionsRepository);
    }
}
