package ru.yandex.canvas.service.multitype.request;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.canvas.service.multitype.singletype.request.AdminRejectOperationSingleTypeRequest;

@ParametersAreNonnullByDefault
public class AdminRejectOperationMultiTypeRequest
        extends MultiCreativeTypeOperationRequest<AdminRejectOperationSingleTypeRequest> {
    @Nullable
    private final String reason;

    private AdminRejectOperationMultiTypeRequest(List<Long> creativeIds, @Nullable String reason) {
        super(creativeIds);
        this.reason = reason;
    }

    @Nullable
    public String getReason() {
        return reason;
    }

    @Override
    public AdminRejectOperationSingleTypeRequest singleTypeRequest(List<Long> filteredIds) {
        return new AdminRejectOperationSingleTypeRequest(filteredIds, reason);
    }

    public static AdminRejectOperationMultiTypeRequest of(List<Long> creativeIds, @Nullable String reason) {
        return new AdminRejectOperationMultiTypeRequest(creativeIds, reason);
    }
}
