package ru.yandex.canvas.service.multitype.request;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;

@ParametersAreNonnullByDefault
public class MultiCreativeTypeOperationRequest<S extends SingleCreativeTypeOperationRequest> {
    private final List<Long> creativeIds;

    public MultiCreativeTypeOperationRequest(List<Long> creativeIds) {
        this.creativeIds = creativeIds;
    }

    public List<Long> getCreativeIds() {
        return creativeIds;
    }

    public S singleTypeRequest(List<Long> filteredIds) {
        return (S) new SingleCreativeTypeOperationRequest(filteredIds);
    }

}
