package ru.yandex.canvas.service.multitype.singletype;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.canvas.model.html5.Creative;
import ru.yandex.canvas.service.html5.Html5CreativesService;
import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.OnCreativeOperationResult;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeIdsOperation;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;

public class RebuildHtml5Operation extends SingleCreativeTypeIdsOperation<Creative, SingleCreativeTypeOperationRequest>
        implements SingleCreativeTypeOperation<SingleCreativeTypeOperationRequest> {
    private final Html5CreativesService html5CreativesService;

    public RebuildHtml5Operation(Html5CreativesService html5CreativesService) {
        this.html5CreativesService = html5CreativesService;
    }

    @Override
    public List<OnCreativeOperationResult> process(List<Creative> creatives) {
        List<OnCreativeOperationResult> result = new ArrayList<>();
        for (Creative creative : creatives) {
            String errorMessage = null;
            if (creative.getSource().getSourceImageInfo() != null) {
                /* Html5 пока не готов, тут нужно проверить не картиночный ли баннер, если картиночный то скачать картинку и
                пересобрать из нее zip-файл после перезалить zip-ник и (спорный момент) внешние библиотеки к нему,
                тут может быть сложно, потому, что надо смотреть на мапу подстановки */
                errorMessage = "Not implemented yet for SourceImage";
            } else {
                try {
                    html5CreativesService.reloadIndex(creative);
                } catch (Exception e) {
                    getLogger().error("Rebuild creative: ", e);
                    errorMessage = "Rebuild html5 creative error: " + e.getMessage();
                }
            }

            OnCreativeOperationResult opResult = errorMessage == null
                    ? OnCreativeOperationResult.ok()
                    : OnCreativeOperationResult.error(errorMessage);

            result.add(opResult);
        }

        return result;
    }

    @Override
    public CreativeType worksOn() {
        return CreativeType.HTML5;
    }
}
