package ru.yandex.canvas.service.multitype.singletype;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.canvas.model.video.Addition;
import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.OnCreativeOperationResult;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeIdsOperation;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;
import ru.yandex.canvas.service.video.VideoCreativesService;

public class RebuildStockVideoOperation
        extends SingleCreativeTypeIdsOperation<Addition, SingleCreativeTypeOperationRequest>
        implements SingleCreativeTypeOperation<SingleCreativeTypeOperationRequest> {

    private final VideoCreativesService videoCreativesService;

    public RebuildStockVideoOperation(VideoCreativesService videoCreativesService) {
        this.videoCreativesService = videoCreativesService;
    }

    @Override
    public List<OnCreativeOperationResult> process(List<Addition> creatives) {
        List<OnCreativeOperationResult> result = new ArrayList<>();
        for (Addition addition : creatives) {
            String errorMessage = null;
            try {
                videoCreativesService.patchStockAdditionVast(addition);
            } catch (Exception e) {
                getLogger().error("Error while rebuilding creative: ", e);
                errorMessage = "Rebuild creatives error: " + e.getMessage();
            }
            OnCreativeOperationResult opResult = errorMessage == null
                    ? OnCreativeOperationResult.ok()
                    : OnCreativeOperationResult.error(errorMessage);

            result.add(opResult);
        }

        return result;
    }

    @Override
    public CreativeType worksOn() {
        return CreativeType.STOCK_VIDEO;
    }
}
