package ru.yandex.canvas.service.multitype.singletype;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.canvas.model.html5.Creative;
import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.OnCreativeOperationResult;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeIdsOperation;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;
import ru.yandex.canvas.service.screenshooters.Html5ScreenshooterHelperService;
import ru.yandex.direct.screenshooter.client.model.ScreenShooterScreenshot;

public class ScreenshotHtml5Operation
        extends SingleCreativeTypeIdsOperation<Creative, SingleCreativeTypeOperationRequest>
        implements SingleCreativeTypeOperation<SingleCreativeTypeOperationRequest> {
    private final Html5ScreenshooterHelperService screenshooterHelperService;

    public ScreenshotHtml5Operation(Html5ScreenshooterHelperService screenshooterHelperService) {
        this.screenshooterHelperService = screenshooterHelperService;
    }

    @Override
    public CreativeType worksOn() {
        return CreativeType.HTML5;
    }

    @Override
    public List<OnCreativeOperationResult> process(List<Creative> creatives) {
        List<OnCreativeOperationResult> result = new ArrayList<>();
        for (Creative creative : creatives) {
            ScreenShooterScreenshot screenshot;
            try {
                screenshot = screenshooterHelperService.getScreenshot(creative,
                        null, creative.getSource().getClientId());

            } catch (Exception e) {
                getLogger().error("Error while reshooting html5 creative screenshot: ", e);
                result.add(OnCreativeOperationResult
                        .error("Exception happened while making screenshot: " + e.getMessage()));
                continue;
            }

            if (screenshot.getIsDone()) {
                result.add(OnCreativeOperationResult.ok());
            } else {
                result.add(OnCreativeOperationResult
                        .error("Screenshot wasn't done, creativeId=" + creative.getId()));
            }
        }
        return result;
    }
}
