package ru.yandex.canvas.service.multitype.singletype;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.canvas.model.CreativeWithId;
import ru.yandex.canvas.model.direct.DirectUploadableHelperService;
import ru.yandex.canvas.service.DirectService;
import ru.yandex.canvas.service.multitype.OnCreativeOperationResult;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeIdsByClientOperation;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;

public abstract class SendToDirectBaseOperation<T extends CreativeWithId>
        extends SingleCreativeTypeIdsByClientOperation<T, SingleCreativeTypeOperationRequest> {
    private final DirectUploadableHelperService<T> uploadableHelperService;
    private final DirectService directService;

    public SendToDirectBaseOperation(DirectUploadableHelperService<T> uploadableHelperService,
            DirectService directService) {
        this.uploadableHelperService = uploadableHelperService;
        this.directService = directService;
    }

    public List<OnCreativeOperationResult> process(Long clientId, List<T> creatives) {
        List<OnCreativeOperationResult> result = new ArrayList<>();
        String errorMessage = null;
        try {
            directService.sendCreatives(null, clientId, creatives, uploadableHelperService);
        } catch (Exception e) {
            getLogger().error("Error while sending creative to direct: ", e);
            errorMessage = "Send creatives error: " + e.getCause();
        }

        OnCreativeOperationResult opResult = errorMessage == null
                ? OnCreativeOperationResult.ok()
                : OnCreativeOperationResult.error(errorMessage);

        creatives.forEach(c -> result.add(opResult));

        return result;
    }
}
