package ru.yandex.canvas.service.multitype.singletype;

import java.util.List;

import ru.yandex.canvas.model.video.Addition;
import ru.yandex.canvas.model.video.addition.RtbStatus;
import ru.yandex.canvas.repository.video.StockVideoAdditionsRepository;
import ru.yandex.canvas.service.RTBHostExportService;
import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;
import ru.yandex.canvas.service.rtbhost.RtbHostUploadHelper;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class SendToRtbHostStockVideoOperation extends SendToRtbHostBaseOperation<Addition>
        implements SingleCreativeTypeOperation<SingleCreativeTypeOperationRequest> {
    private final StockVideoAdditionsRepository stockVideoAdditionsRepository;

    public SendToRtbHostStockVideoOperation(
            RtbHostUploadHelper<Addition> rtbHostUploadHelper,
            RTBHostExportService rtbHostExportService,
            StockVideoAdditionsRepository stockVideoAdditionsRepository) {
        super(rtbHostUploadHelper, rtbHostExportService);
        this.stockVideoAdditionsRepository = stockVideoAdditionsRepository;
    }

    @Override
    public CreativeType worksOn() {
        return CreativeType.STOCK_VIDEO;
    }

    @Override
    public void onSuccess(List<Addition> creatives) {
        stockVideoAdditionsRepository.updateStatusRtb(mapList(creatives, Addition::getCreativeId), RtbStatus.SENT);
    }
}
