package ru.yandex.canvas.service.multitype.singletype;

import java.util.List;

import ru.yandex.canvas.model.video.Addition;
import ru.yandex.canvas.model.video.addition.RtbStatus;
import ru.yandex.canvas.repository.video.VideoAdditionsRepository;
import ru.yandex.canvas.service.RTBHostExportService;
import ru.yandex.canvas.service.multitype.CreativeType;
import ru.yandex.canvas.service.multitype.SingleCreativeTypeOperation;
import ru.yandex.canvas.service.multitype.singletype.request.SingleCreativeTypeOperationRequest;
import ru.yandex.canvas.service.rtbhost.RtbHostUploadHelper;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class SendToRtbHostVideoOperation extends SendToRtbHostBaseOperation<Addition>
        implements SingleCreativeTypeOperation<SingleCreativeTypeOperationRequest> {
    private final VideoAdditionsRepository videoAdditionsRepository;

    public SendToRtbHostVideoOperation(
            RtbHostUploadHelper<Addition> rtbHostUploadHelper,
            RTBHostExportService rtbHostExportService, VideoAdditionsRepository videoAdditionsRepository) {
        super(rtbHostUploadHelper, rtbHostExportService);
        this.videoAdditionsRepository = videoAdditionsRepository;
    }

    @Override
    public CreativeType worksOn() {
        return CreativeType.VIDEO;
    }

    @Override
    public void onSuccess(List<Addition> creatives) {
        videoAdditionsRepository.updateStatusRtb(mapList(creatives, Addition::getCreativeId), RtbStatus.SENT);
    }
}
