package ru.yandex.canvas.service.preview;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.html_builder.CreativeHtmlPreviewWriter;
import ru.yandex.canvas.model.html_builder.GeoPinCreativeHtmlWriter;
import ru.yandex.canvas.model.html_builder.InBannerHtmlCreativeWriter;
import ru.yandex.canvas.service.html5.Preview;

import static ru.yandex.canvas.service.PresetsService.GEO_PIN_PRESET_IDS;
import static ru.yandex.canvas.service.PresetsService.IN_BANNER_PRESET_IDS;

public class CreativePreviewBuilderImpl implements CreativePreviewBuilder {
    private final GeoPinCreativeHtmlWriter geoPinCreativeHtmlWriter;
    private final CreativeHtmlPreviewWriter creativeHtmlPreviewWriter;
    private final InBannerHtmlCreativeWriter inBannerHtmlCreativeWriter;

    public CreativePreviewBuilderImpl(GeoPinCreativeHtmlWriter geoPinCreativeHtmlWriter,
                                      CreativeHtmlPreviewWriter creativeHtmlPreviewWriter,
                                      InBannerHtmlCreativeWriter inBannerHtmlCreativeWriter) {
        this.geoPinCreativeHtmlWriter = geoPinCreativeHtmlWriter;
        this.creativeHtmlPreviewWriter = creativeHtmlPreviewWriter;
        this.inBannerHtmlCreativeWriter = inBannerHtmlCreativeWriter;
    }

    @Override
    public String buildCreativeHtmlForPreview(CreativeDocument creativeDocument) {
        if (creativeDocument.getPresetId() == null) {
            return creativeHtmlPreviewWriter.composeCreativeHTML(creativeDocument);
        } else if (GEO_PIN_PRESET_IDS.contains(creativeDocument.getPresetId())) {
            return geoPinCreativeHtmlWriter.composeCreativeHTML(creativeDocument);
        } else if (IN_BANNER_PRESET_IDS.contains(creativeDocument.getPresetId())) {
            return inBannerHtmlCreativeWriter.composeCreativeHTML(creativeDocument,
                    null, Preview.DataParams.defaultDataParams().toJson(), null);
        } else {
            return creativeHtmlPreviewWriter.composeCreativeHTML(creativeDocument);
        }
    }
}
