package ru.yandex.canvas.service.rtbhost;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.protobuf.util.JsonFormat;

import ru.yandex.adv.direct.CreativeParameters;

public class CreativeParametersSerializer extends JsonSerializer<CreativeParameters> {
    @Override
    public void serialize(CreativeParameters parameters, JsonGenerator gen,
                          SerializerProvider serializers) throws IOException {
        var printer = JsonFormat.printer().omittingInsignificantWhitespace();
        gen.writeRawValue(printer.print(parameters));
    }
}
