package ru.yandex.canvas.service.rtbhost.helpers;

import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.service.rtbhost.RtbHostUploadHelper;
import ru.yandex.canvas.service.rtbhost.helpers.creative.CreativesDspUploadHelper;
import ru.yandex.canvas.service.rtbhost.helpers.creative.GeoPinDspUploadHelper;
import ru.yandex.canvas.service.rtbhost.helpers.creative.InBannerDspUploadHelper;
import ru.yandex.direct.bs.dspcreative.model.DspCreativeExportEntry;

import static ru.yandex.canvas.service.PresetsService.GEO_PIN_PRESET_IDS;
import static ru.yandex.canvas.service.PresetsService.IN_BANNER_PRESET_IDS;

public class CreativesDspUploadFacade implements RtbHostUploadHelper<CreativeDocument> {

    private final CreativesDspUploadHelper creativesDspUploadHelper;
    private final GeoPinDspUploadHelper geoPinDspUploadHelper;
    private final InBannerDspUploadHelper inBannerDspUploadHelper;

    public CreativesDspUploadFacade(CreativesDspUploadHelper creativesDspUploadHelper,
                                    GeoPinDspUploadHelper geoPinDspUploadHelper,
                                    InBannerDspUploadHelper inBannerDspUploadHelper) {
        this.creativesDspUploadHelper = creativesDspUploadHelper;
        this.geoPinDspUploadHelper = geoPinDspUploadHelper;
        this.inBannerDspUploadHelper = inBannerDspUploadHelper;
    }

    @Override
    public DspCreativeExportEntry toImportDspCreativeEntry(CreativeDocument creativeDocument,
                                                           ObjectMapper objectMapper) {
        if (creativeDocument.getPresetId() == null) {
            return creativesDspUploadHelper.toImportDSPCreativeEntry(creativeDocument, objectMapper);
        } else if (GEO_PIN_PRESET_IDS.contains(creativeDocument.getPresetId())) {
            return geoPinDspUploadHelper.toImportDSPCreativeEntry(creativeDocument, objectMapper);
        } else if (IN_BANNER_PRESET_IDS.contains(creativeDocument.getPresetId())) {
            return inBannerDspUploadHelper.toImportDspCreativeEntry(creativeDocument, objectMapper);
        } else {
            return creativesDspUploadHelper.toImportDSPCreativeEntry(creativeDocument, objectMapper);
        }

    }
}
