package ru.yandex.canvas.service.rtbhost.helpers.creative;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.html_builder.CreativeHtmlRtbHostWriter;
import ru.yandex.canvas.service.rtbhost.ConstructorData;
import ru.yandex.direct.bs.dspcreative.model.DspCreativeExportEntry;

public class CreativesDspUploadHelper {
    private final CreativeHtmlRtbHostWriter creativeHtmlRtbHostWriter;

    public CreativesDspUploadHelper(CreativeHtmlRtbHostWriter creativeHtmlRtbHostWriter) {
        this.creativeHtmlRtbHostWriter = creativeHtmlRtbHostWriter;
    }

    public DspCreativeExportEntry toImportDSPCreativeEntry(CreativeDocument creativeDocument,
                                                           ObjectMapper objectMapper) {

        try {
            boolean isAdaptive = creativeDocument.getData().getOptions().getIsAdaptive();
            int width = isAdaptive ? 0 : creativeDocument.getData().getWidth();
            int height = isAdaptive ? 0 : creativeDocument.getData().getHeight();

            return DspCreativeExportEntry.builder()
                    .setDspId(1L)
                    .setCreativeId(creativeDocument.getId())
                    .setCreativeVersionId(creativeDocument.getId())
                    .setData(creativeHtmlRtbHostWriter.composeCreativeHTML(creativeDocument))
                    .setConstructorData(objectMapper.writeValueAsString(new ConstructorData(
                            creativeDocument.getData().onlyVisibleData())))
                    .setStaticData(String.format("{\"creative_id\":\"%d\"}", creativeDocument.getId()))
                    .setEnabled(true)
                    .setStatic(false)
                    .setTag("yabs")
                    .setPostmoderated(true)
                    .setVideo(false)
                    .setAudio(false)
                    .setWidth(width)
                    .setHeight(height)
                    .setIsAdaptive(creativeDocument.getData().getOptions().getIsAdaptive())
                    .build();

        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

}
