package ru.yandex.canvas.service.sandbox;

/**
 * check https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/common/types/client.py
 */
public enum ClientTag implements ClientTagsQuery {

    // PURPOSE
    // Please don't use these tags if you are not sure that you know what you are doing.
    GENERIC, // Item("generic sandbox clients - default tag", default=True)
    SERVER, // Item("sandbox-server* hosts")
    STORAGE, // Item("sandbox-storage* hosts")
    POSTEXECUTE, // Item("Hosts where transient statuses (STOPPING, RELEASING) are executing")
    RTY, // Item("sandbox-rty* hosts")
    BROWSER, // Item("hosts for Browser testing")
    BROWSER_MOBILE, // Item("Hosts for mobile browser testing")
    YABS, //Item("hosts for YABS testing")
    UKROP, //Item("sandbox-ukrop* hosts for release brunches build")
    SKYNET, //Item("hosts for skynet build")
    PORTO, //Item("hosts with Porto")
    WS, //Item("wsXX-* hosts for Report testing")
    OXYGEN, //Item("sandbox-oxygen* hosts")
    COCAINE, //Item("hosts for needs of Cocaine")
    ANTISPAM, //Item("sandbox-antispam* hosts")
    MARKET, //Item("Hosts for market")
    ACCEPTANCE, //Item("hosts performing the acceptance of the Sandbox")
    OTT, //Item("Media services dedicated hosts for fast video converting tasks")
    VOID, //Item("Special tag to define empty set of hosts")
    SDC, //Item("Dedicated hosts for self-driving cars project (SANDBOX-6698)")

    // VIRTUAL:
    LXC, //Item("hosts where tasks are executing in LXC-containter (multios clients, priveleged tasks, etc...)")
    PORTOD, //Item("hosts where tasks are executing in Porto containters", default=False)
    OPENSTACK, //Item("hosts in openstack")

    // DENSITY:
    MULTISLOT, //Item("Multi slot host (1 CPU, 8 GiB)", default=False)
    CORES1, //Item("Multi slot host (1 CPU, 8 GiB)", default=False)
    CORES4, //Item("Fat multi slot host (4 CPU, 16 GiB)", default=False)
    CORES8, //Item("Fat multi slot host (8 CPU, 32 GiB)", default=False)
    CORES16, //Item("CPU with 16 cores")
    CORES24, //Item("CPU with 24 cores")
    CORES32, //Item("CPU with 32 cores")
    CORES56, //Item("CPU with 56 cores")
    CORES64, //Item("CPU with 64 cores")

    // OS:
    LINUX, // LINUX_*
    // Group LINUX
    LINUX_LUCID, //Item("Linux Ubuntu 10.04")
    LINUX_PRECISE, //Item("Linux Ubuntu 12.04")
    LINUX_TRUSTY, //Item("Linux Ubuntu 14.04")
    LINUX_XENIAL, //Item("Linux Ubuntu 16.04")
    LINUX_BIONIC, //Item("Linux Ubuntu 18.04")
    OSX_MAVERICKS, //Item("OS X 10.9")
    OSX_YOSEMITE, //Item("OS X 10.10")
    OSX_EL_CAPITAN, //Item("OS X 10.11")
    OSX_SIERRA, //Item("OS X 10.12")
    OSX_HIGH_SIERRA, //Item("OS X 10.13")
    CYGWIN, //Item("Windows/Cygwin platform (experimental)")
    FREEBSD, //Item("FreeBSD (deprecated)")

    // CPU:
    INTEL_E5_2683V4, //Item()
    INTEL_E5_2683, //Item()
    INTEL_E5_2650, //Item()
    INTEL_E5_2660, //Item()
    INTEL_E5_2660V1, //Item()
    INTEL_E5_2660V4, //Item()
    INTEL_E5645, //Item()
    INTEL_E312XX, //Item()
    INTEL_3720QM, //Item()
    INTEL_X5675, //Item()
    AMD6176, //Item()
    ARM, //Item()
    KVM, //Item()

    // DISK:
    HDD, //Item("Client has HDD")
    SSD, //Item("Client has SSD")

    // NET:
    IPV4, //Item("Client has IPv4-address")
    IPV6, //Item("Client has IPv6-address")

    // FEATURES:
    NEW_LAYOUT, //Item("New resources location layout")
    SQUASHFS_TASKS_IMAGE, //Item("SANDBOX-5068: Experimental feature - use SquashFS tasks image")

    // VCS:
    ARCADIA_HG, //Item("Has actual Arcadia Hg cache")

    // SERVICE:
    // Don't even think about using these tags
    NEW, //Item("New client")
    MAINTENANCE,
    ; //Item("Client is on maintenance")


    @Override
    public String build() {
        return toString();
    }

    @Override
    public String buildWrapped() {
        return toString();
    }


}
