package ru.yandex.canvas.service.scraper;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
public class ScraperException extends RuntimeException {
    @Nullable
    private String systemInfo;

    public ScraperException(@NonNls String message, @Nullable String systemInfo, Throwable cause) {
        super(message, cause);
        this.systemInfo = systemInfo;
    }

    public ScraperException(@NonNls String message, @Nullable String systemInfo) {
        super(message);
        this.systemInfo = systemInfo;
    }

    @Nullable
    public String getSystemInfo() {
        return systemInfo;
    }
}
