package ru.yandex.canvas.service.scraper;

import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(HttpStatus.NOT_FOUND)
public class ScraperUnreachableUrlException extends ScraperException {
    public ScraperUnreachableUrlException(@NonNls String message, @Nullable String systemInfo, Throwable cause) {
        super(message, systemInfo, cause);
    }

    public ScraperUnreachableUrlException(@NonNls String message, @Nullable String systemInfo) {
        super(message, systemInfo);
    }
}
