package ru.yandex.canvas.service.scraper;

import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;

import org.jetbrains.annotations.NotNull;

public class URLHelper {
    private static final Pattern SCHEME_PRESENT_REGEXP = Pattern.compile("(^http://.*|^https://.*)");

    private URLHelper() {
    }

    /**
     * @return url if scheme specified and 'http://' + userUrl if not
     * @throws IllegalArgumentException on invalid url
     */
    public static URL normalizeUrl(@NotNull String userUrl) {
        String urlStr = userUrl.trim();
        if (!SCHEME_PRESENT_REGEXP.matcher(urlStr).matches()) {
            urlStr = "http://" + userUrl;
        }

        try {
            return idnEncodeNationalHost(new URL(urlStr));
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static URL idnEncodeNationalHost(@NotNull URL url) {
        if (url.getHost() == null) {
            return url;
        }
        try {
            return new URL(url.getProtocol(), IDN.toASCII(url.getHost()), url.getPort(), url.getFile());
        } catch (MalformedURLException e) {
            throw new AssertionError("Error while processing url " + url, e);
        }
    }
}
