package ru.yandex.canvas.service.screenshooters;

import java.util.Collections;

import javax.annotation.Nullable;

import com.mongodb.client.result.UpdateResult;

import ru.yandex.canvas.model.CreativeWithScreenshot;
import ru.yandex.canvas.model.direct.DirectUploadableHelperService;
import ru.yandex.canvas.service.DirectService;
import ru.yandex.direct.screenshooter.client.model.ScreenShooterScreenshot;

public abstract class AbstractScreenshooterHelperService<T extends CreativeWithScreenshot> implements ScreenshooterHelperService<T> {
    private final DirectService directService;

    protected AbstractScreenshooterHelperService(DirectService directService) {
        this.directService = directService;
    }


    abstract protected ScreenShooterScreenshot takeScreenshotFromScreenshooter(T creative);

    abstract protected UpdateResult updateCreativeScreenshotUrl(T creative, String screenshotUrl,
                                                                Boolean screenshotIsDone,
                                                                @Nullable Long userId,
                                                                Long clientId);

    abstract protected DirectUploadableHelperService<T> getDirectUploadHelper();

    abstract protected boolean needReuploadToDirect(T creative);

    @Override
    public ScreenShooterScreenshot getScreenshot(T creative, Long userId, Long clientId) {
        ScreenShooterScreenshot screenshot = this.takeScreenshotFromScreenshooter(creative);

        if (screenshot.getIsDone() && (creative.fetchScreenshotUrl() == null || !creative.fetchScreenshotUrl().equals(screenshot.getUrl()))) {
            boolean needReupload = needReuploadToDirect(creative);
            DirectUploadableHelperService<T> directUploadableHelperService = getDirectUploadHelper();

            this.updateCreativeScreenshotUrl(creative, screenshot.getUrl(), screenshot.getIsDone(), userId,
                    clientId);

            if (needReupload && directUploadableHelperService != null && clientId != null && clientId != 0) {
                directService.sendCreatives(userId, clientId, Collections.singletonList(creative),
                        directUploadableHelperService);
            }

        }

        return screenshot;
    }
}
