package ru.yandex.canvas.service.screenshooters;

import javax.annotation.Nullable;

import com.mongodb.client.result.UpdateResult;

import ru.yandex.canvas.model.direct.DirectUploadableHelperService;
import ru.yandex.canvas.model.html5.Creative;
import ru.yandex.canvas.repository.html5.BatchesRepository;
import ru.yandex.canvas.service.DirectService;
import ru.yandex.canvas.service.direct.Html5CreativeDirectUploadHelper;
import ru.yandex.direct.screenshooter.client.model.ScreenShooterScreenshot;

public class Html5ScreenshooterHelperService extends AbstractScreenshooterHelperService<Creative> {
    private final Html5CreativeDirectUploadHelper html5CreativeDirectUploadHelper;
    private final Html5SourceScreenshooterHelperService html5SourceScreenshooterHelperService;
    private final BatchesRepository batchesRepository;

    public Html5ScreenshooterHelperService(Html5CreativeDirectUploadHelper html5CreativeDirectUploadHelper,
                                           DirectService directService,
                                           Html5SourceScreenshooterHelperService html5SourceScreenshooterHelperService, BatchesRepository batchesRepository) {
        super(directService);
        this.html5CreativeDirectUploadHelper = html5CreativeDirectUploadHelper;
        this.html5SourceScreenshooterHelperService = html5SourceScreenshooterHelperService;
        this.batchesRepository = batchesRepository;
    }

    @Override
    public ScreenShooterScreenshot takeScreenshotFromScreenshooter(Creative creative) {
        return html5SourceScreenshooterHelperService.takeScreenshotFromScreenshooter(creative.getSource());
    }

    @Override
    public UpdateResult updateCreativeScreenshotUrl(Creative creative, String screenshotUrl, Boolean screenshotIsDone,
                                                    @Nullable Long userId, Long clientId) {
        batchesRepository.updateCreativeScreenshotUrl(creative.getId(), screenshotUrl);
        return html5SourceScreenshooterHelperService.updateCreativeScreenshotUrl(creative.getSource(),
                screenshotUrl, screenshotIsDone, userId, clientId);
    }

    @Override
    protected DirectUploadableHelperService<Creative> getDirectUploadHelper() {
        return html5CreativeDirectUploadHelper;
    }

    @Override
    protected boolean needReuploadToDirect(Creative creative) {
        return creative.getId() != null;
    }
}
