package ru.yandex.canvas.service.screenshooters;

import javax.annotation.Nullable;

import com.mongodb.client.result.UpdateResult;
import org.bson.BsonValue;

import ru.yandex.canvas.model.direct.DirectUploadableHelperService;
import ru.yandex.canvas.model.html5.Source;
import ru.yandex.canvas.repository.html5.SourcesRepository;
import ru.yandex.canvas.service.DirectService;
import ru.yandex.canvas.service.ScreenshooterService;
import ru.yandex.canvas.service.html5.Html5PhotoStudio;
import ru.yandex.direct.screenshooter.client.model.ScreenShooterScreenshot;

public class Html5SourceScreenshooterHelperService extends AbstractScreenshooterHelperService<Source> {
    private final ScreenshooterService screenshooterService;
    private final SourcesRepository sourcesRepository;

    public Html5SourceScreenshooterHelperService(ScreenshooterService screenshooterService,
                                                 SourcesRepository sourcesRepository, DirectService directService) {
        super(directService);
        this.screenshooterService = screenshooterService;
        this.sourcesRepository = sourcesRepository;
    }

    @Override
    public ScreenShooterScreenshot takeScreenshotFromScreenshooter(Source source) {
        ScreenShooterScreenshot screenshot = screenshooterService.getScreenshotFromUrl(source.getPreviewUrl(),
                source.getWidth(), source.getHeight());
        if (source.getExpandedHtmlUrl() != null) {
            //скриншот для баннеров со сложной механикой
            var studio = new Html5PhotoStudio(source, screenshot.getUrl());
            ScreenShooterScreenshot screenshotExpanded = screenshooterService.getScreenshotFromHtml(studio.asHtml(),
                    studio.getWidth(), studio.getHeight());
            return screenshotExpanded.withUrlMainBanner(screenshot.getUrl());
        }
        return screenshot;
    }

    @Override
    public UpdateResult updateCreativeScreenshotUrl(Source source, String screenshotUrl, Boolean screenshotIsDone,
                                                    @Nullable Long userId, Long clientId) {
        source.setScreenshotUrl(screenshotUrl);
        source.setScreenshotIsDone(screenshotIsDone);

        if (source.getId() == null) {
            return new UpdateResult() {
                @Override
                public boolean wasAcknowledged() {
                    return false;
                }

                @Override
                public long getMatchedCount() {
                    return 0;
                }

                @Override
                public boolean isModifiedCountAvailable() {
                    return false;
                }

                @Override
                public long getModifiedCount() {
                    return 0;
                }

                @Override
                public BsonValue getUpsertedId() {
                    return null;
                }
            };
        }

        return sourcesRepository.updateScreenshotUrl(source.getId(), screenshotUrl, screenshotIsDone);
    }

    @Override
    protected DirectUploadableHelperService<Source> getDirectUploadHelper() {
        return null;
    }

    @Override
    protected boolean needReuploadToDirect(Source creative) {
        return false;
    }
}
