package ru.yandex.canvas.service.screenshooters;

import java.io.IOException;
import java.net.URISyntaxException;

import javax.annotation.Nullable;

import com.mongodb.client.result.UpdateResult;

import ru.yandex.canvas.model.direct.DirectUploadableHelperService;
import ru.yandex.canvas.model.video.Addition;
import ru.yandex.canvas.model.video.files.VideoSource;
import ru.yandex.canvas.repository.video.VideoAdditionsRepository;
import ru.yandex.canvas.service.DirectService;
import ru.yandex.canvas.service.ScreenshooterService;
import ru.yandex.canvas.service.direct.VideoAdditionDirectUploadHelper;
import ru.yandex.canvas.service.video.DCParams;
import ru.yandex.canvas.service.video.PreviewData;
import ru.yandex.canvas.service.video.StaticPreviewService;
import ru.yandex.canvas.service.video.VideoPresetsService;
import ru.yandex.direct.screenshooter.client.model.ScreenShooterScreenshot;

public class VideoAdditionScreenshooterHelperService extends AbstractScreenshooterHelperService<Addition> {
    private final VideoPresetsService presetsService;
    private final ScreenshooterService screenshooterService;
    private final VideoAdditionsRepository additionsRepository;
    private final VideoAdditionDirectUploadHelper videoAdditionDirectUploadHelper;
    private final StaticPreviewService staticPreviewService;

    public VideoAdditionScreenshooterHelperService(VideoPresetsService presetsService,
                                                   ScreenshooterService screenshooterService,
                                                   VideoAdditionsRepository additionsRepository,
                                                   DirectService directService,
                                                   VideoAdditionDirectUploadHelper videoAdditionDirectUploadHelper,
                                                   StaticPreviewService staticPreviewService) {
        super(directService);
        this.presetsService = presetsService;
        this.screenshooterService = screenshooterService;
        this.additionsRepository = additionsRepository;
        this.videoAdditionDirectUploadHelper = videoAdditionDirectUploadHelper;
        this.staticPreviewService = staticPreviewService;
    }

    @Override
    public ScreenShooterScreenshot takeScreenshotFromScreenshooter(Addition creative) {
        var videoPreset = presetsService.getPreset(creative.getPresetId());
        var defaultPreviewData = new PreviewData(videoPreset.getUseDefaultBodyAndTitle());
        var dcParams = new DCParams(defaultPreviewData, creative.getData(), false);
        var staticPreview = staticPreviewService.initStaticPreview(creative, dcParams, videoPreset);

        VideoSource videoSource = staticPreview.getMovie().getVideoSource();

        try {
            return screenshooterService
                    .getScreenshotFromHtml(staticPreview.makeStaticTemplate(), videoSource.getThumbnail().getWidth(),
                            videoSource.getThumbnail().getHeight());
        } catch (IOException | URISyntaxException e) {
            return new ScreenShooterScreenshot().withIsDone(false);
        }
    }

    @Override
    public UpdateResult updateCreativeScreenshotUrl(Addition creative, String screenshotUrl, Boolean screenshotIsDone,
                                                    @Nullable Long userId, Long clientId) {
        creative.setScreenshotUrl(screenshotUrl);
        creative.setScreenshotIsDone(screenshotIsDone);

        return additionsRepository.updateScreenshotUrl(creative.getCreativeId(), screenshotUrl, screenshotIsDone);
    }

    @Override
    protected DirectUploadableHelperService<Addition> getDirectUploadHelper() {
        return videoAdditionDirectUploadHelper;
    }

    @Override
    protected boolean needReuploadToDirect(Addition creative) {
        return creative.getId() != null;
    }
}
