package ru.yandex.canvas.service.video;

import java.io.IOException;
import java.net.URI;

import ru.yandex.canvas.model.video.AudioFiles;
import ru.yandex.canvas.model.video.files.AudioSource;
import ru.yandex.canvas.service.SandBoxService;

public interface AudioServiceInterface {
    AudioSource lookupAudio(String audioId, Long clientId);

    AudioSource upload(byte[] content, String filename, Long clientId, VideoCreativeType videoCreativeType,
                       Long presetId) throws IOException;

    AudioSource upload(URI url, String filename, Long clientId, VideoCreativeType videoCreativeType, Long presetId) throws IOException;

    AudioFiles updateConvertingFile(String fileId, SandBoxService.SandboxFfConversionTaskOutput output);
}
