package ru.yandex.canvas.service.video;

import java.util.Locale;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum Geometry {
    NONE,
    // OLD,
    UNIVERSAL,
    WIDE,
    TALL,
    SQUARE;

    @JsonValue
    public String getValue() {
        return toString().toLowerCase();
    }

    @JsonCreator
    public static VideoCreativeType fromString(String name) {
        return VideoCreativeType.valueOf(name.toUpperCase(Locale.ROOT));
    }


}
