package ru.yandex.canvas.service.video;

import java.net.URI;
import java.util.Enumeration;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import org.springframework.http.HttpHeaders;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpUtils {
    private HttpUtils() {
    }

    public static void setTestHeaders(HttpHeaders headers) {
        RequestAttributes attribs = RequestContextHolder.getRequestAttributes();

        if (attribs == null) {
            return;
        }

        HttpServletRequest request = ((ServletRequestAttributes) attribs).getRequest();

        if (request == null) {
            return;
        }

        Enumeration<String> headerNames = request.getHeaderNames();

        if (headerNames == null) {
            return;
        }

        while (headerNames.hasMoreElements()) {
            String name = headerNames.nextElement();

            if (name.toUpperCase().startsWith("X-CANVAS-TEST-")) {
                headers.add(name, request.getHeader(name));
            }
        }
    }

    public static URI makeURI(String url) {
        try {
            return URI.create(url);
        } catch (Exception e) {
            // значит скорее всего url не url-encoded, пробуем еще раз
            return UriComponentsBuilder.fromUriString(url).build().toUri();
        }
    }

    public static String makeFilenameFromUrl(URI uri) {
        String filename = null;

        if (uri.getPath() != null) {
            String[] path = uri.getPath().split("/");
            if (path.length > 0) {
                filename = path[path.length - 1];
            }
        }

        if (filename == null) {
            filename = UUID.randomUUID().toString();
        }

        return filename;
    }

}
