package ru.yandex.canvas.service.video;

import java.io.IOException;
import java.util.List;

import ru.yandex.canvas.model.video.CleanupOldConversionsResult;
import ru.yandex.canvas.model.video.VideoFiles;
import ru.yandex.canvas.model.video.files.FileType;
import ru.yandex.canvas.model.video.files.Movie;
import ru.yandex.canvas.service.SandBoxService;

public interface MovieServiceInterface extends VideoFilesServiceInterface<Movie, MovieService.MarkedMovieIds> {
    Movie lookupMovie(String videoId, String audioId, Long clientId, Long presetId);

    void updateConvertingFile(String fileId, SandBoxService.SandboxConversionTaskOutput output) throws IOException;

    CleanupOldConversionsResult cleanupOldConversions(long ageSeconds);

    VideoFiles getFileById(String id, FileType type, Long clientId);

    VideoFiles getFileByIdInternal(String id);

    List<VideoFiles> findOldConvertingCmsFiles(long ageSeconds);

}
