package ru.yandex.canvas.service.video;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;

import ru.yandex.canvas.service.TankerKeySet;

//see CANVAS-709 / DIRECT-70375
@JsonIgnoreProperties(ignoreUnknown = true)
public class PreviewData {

    @Nullable
    private String title;

    @Nullable
    private String body;

    @Nullable
    //@URL TODO
    private String url = "http://yandex.ru";


    @Nullable
    private String buttonUrl;

    @Nullable
    private String domain;

    @Nullable
    private String punyDomain;

    @Nullable
    @Pattern(regexp = "^(age)?\\d*\\+?$")
    private String age;

    @Nullable
    private String warning;

    // FIXME: remove fallbacks eventually, see https://st.yandex-team.ru/CANVAS-709

    @Nullable //TODO enum default
    private String lang;

    @Nullable
    @JsonProperty("banner_flags") //TODO default ""
    private String bannerFlags;

    @Nullable
    @JsonProperty("dynamic_disclaimer") //TODO default 0
    private String dynamicDisclaimer;

    @Nullable
    @JsonProperty("images")
    private Object images;

    @Nullable
    @JsonProperty("sitelinks")
    private Object sitelinks;

    @Nullable
    @JsonProperty("secondTitle")
    private Object secondTitle;

    @Nullable
    private Boolean useDefaultBodyAndTitle;

    public PreviewData() {
        this.useDefaultBodyAndTitle = false;
    }

    public PreviewData(@Nullable Boolean useDefaultBodyAndTitle) {
        this.useDefaultBodyAndTitle = useDefaultBodyAndTitle;
    }

    @Nonnull
    public String getTitle() {
        if (title == null) {
            if (useDefaultBodyAndTitle != null && useDefaultBodyAndTitle) {
                return TankerKeySet.VIDEO.key("preview_title_stub");
            } else {
                return "";
            }
        } else {
            return title;
        }
    }

    public PreviewData setTitle(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    public String getBody() {
        if (body == null) {
            if (useDefaultBodyAndTitle != null && useDefaultBodyAndTitle) {
                return TankerKeySet.VIDEO.key("preview_body_stub");
            } else {
                return "";
            }
        } else {
            return body;
        }
    }

    @JsonSetter("url")
    public void setNonNullUrl(String url) {
        if (url != null && !url.isBlank()) {
            this.url = url;
        }
    }

    public PreviewData setBody(@Nullable String body) {
        this.body = body;
        return this;
    }

    public String getUrl() {
        return url == null ? TankerKeySet.VIDEO.key("preview_url_stub") : url;
    }

    public PreviewData setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getButtonUrl() {
        return buttonUrl;
    }

    public PreviewData setButtonUrl(String buttonUrl) {
        this.buttonUrl = buttonUrl;
        return this;
    }

    @Nullable
    public String getDomain() {
        return domain == null ? TankerKeySet.VIDEO.key("preview_domain_stub") : domain;
    }

    public PreviewData setDomain(@Nullable String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    public String getPunyDomain() {
        return punyDomain == null ? TankerKeySet.VIDEO.key("preview_punydomain_stub") : punyDomain;
    }

    public PreviewData setPunyDomain(@Nullable String punyDomain) {
        this.punyDomain = punyDomain;
        return this;
    }

    public String getAge() {
        if (age == null) {
            return "18";
        } else {
            return age.replace("+", "").replace("age", "");
        }
    }

    public PreviewData setAge(String age) {
        this.age = age;
        return this;
    }

    public String getWarning() {
        return warning == null ? TankerKeySet.VIDEO.key("preview_warning_stub") : warning;
    }

    public PreviewData setWarning(String warning) {
        this.warning = warning;
        return this;
    }

    public String getLang() {
        return lang == null ? "ru" : lang;
    }

    public PreviewData setLang(String lang) {
        this.lang = lang;
        return this;
    }

    public String getBannerFlags() {
        return bannerFlags == null ? "" : bannerFlags;
    }

    public PreviewData setBannerFlags(String bannerFlags) {
        this.bannerFlags = bannerFlags;
        return this;
    }

    public String getDynamicDisclaimer() {
        return dynamicDisclaimer == null ? "0" : dynamicDisclaimer;
    }

    public PreviewData setDynamicDisclaimer(String dynamicDisclaimer) {
        this.dynamicDisclaimer = dynamicDisclaimer;
        return this;
    }

    @Nullable
    public Object getImages() {
        return images;
    }

    public PreviewData setImages(@Nullable Object images) {
        this.images = images;
        return this;
    }

    @Nullable
    public Object getSitelinks() {
        return sitelinks;
    }

    public PreviewData setSitelinks(@Nullable Object sitelinks) {
        this.sitelinks = sitelinks;
        return this;
    }

    @Nullable
    public Object getSecondTitle() {
        return secondTitle;
    }

    public PreviewData setSecondTitle(@Nullable Object secondTitle) {
        this.secondTitle = secondTitle;
        return this;
    }
}
