package ru.yandex.canvas.service.video;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;

import javax.validation.constraints.NotNull;

import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nullable;

import ru.yandex.canvas.TimeDelta;
import ru.yandex.canvas.service.video.presets.VideoPreset;

import static ru.yandex.canvas.service.video.presets.PresetTag.NON_SKIPPABLE_CPM;
import static ru.yandex.canvas.service.video.presets.PresetTag.PRICE_CAMPS_NON_SKIPPABLE_CPM;

public class SkipOffsetUtils {
    public static final String ENABLE_NON_SKIPPABLE_VIDEO_15_SECONDS = "enable_non_skippable_video_15_seconds";
    public static final String ENABLE_NON_SKIPPABLE_VIDEO_20_SECONDS = "enable_non_skippable_video_20_seconds";
    private static final Map<String, Long> FEATURE_TO_SKIP_OFFSET_MAP =
            Map.of(ENABLE_NON_SKIPPABLE_VIDEO_15_SECONDS, 15L,
                    ENABLE_NON_SKIPPABLE_VIDEO_20_SECONDS, 20L);

    @Nullable
    public static TimeDelta getSkipOffset(@NotNull VideoPreset preset, Set<String> features, Long delay) {
        if (preset.videoCreativeType().equals(VideoCreativeType.CPM_AUDIO)) {
            return null;
        }
        var skipoffset =  EntryStream.of(FEATURE_TO_SKIP_OFFSET_MAP)
                .filterKeys(feature -> (preset.getTags().contains(NON_SKIPPABLE_CPM)
                    || preset.getTags().contains(PRICE_CAMPS_NON_SKIPPABLE_CPM))
                    && features.contains(feature))
                .values()
                .max(Comparator.naturalOrder())
                .map(TimeDelta::new)
                .orElse(preset.getSkipOffset());
        if (skipoffset.asSeconds() >= delay - 2) {
            return null;
        } else {
            return skipoffset;
        }
    }
}
