package ru.yandex.canvas.service.video;

import java.io.IOException;
import java.net.URISyntaxException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.canvas.model.video.Addition;
import ru.yandex.canvas.model.video.addition.options.AdditionElementOptions;
import ru.yandex.canvas.service.video.presets.VideoPreset;

public class StaticPreviewService {
    private static final Logger logger = LoggerFactory.getLogger(StaticPreviewService.class);

    private final MovieServiceInterface movieService;
    private final VideoPresetsService presetsService;

    public StaticPreviewService(MovieServiceInterface movieService, VideoPresetsService presetsService) {
        this.movieService = movieService;
        this.presetsService = presetsService;
    }

    public StaticPreview initStaticPreview(Addition addition, DCParams dcParams, VideoPreset videoPreset) {
        AdditionElementOptions options = addition.findFilesOptions();
        var movie = movieService.lookupMovie(options.getVideoId(), options.getAudioId(), addition.getClientId(),
                addition.getPresetId());

        var preview = new StaticPreview()
                .setBundleName(addition.getData().getBundle().getName())
                .setDcParams(dcParams)
                .setSkipOffset(videoPreset.getSkipOffset())
                .setElements(addition.getData().getElements())
                .setControlAllowed(videoPreset.isControlsAllowed())
                .setMovie(movie);
        if (movie.getVideoSource().getThumbnail() != null) {
            preview.setHeight(movie.getVideoSource().getThumbnail().getHeight())
                    .setWidth(movie.getVideoSource().getThumbnail().getWidth());
        } else {
            logger.warn("Thumbnail is null, video source id: {}", movie.getVideoSource().getId());
        }
        return preview;
    }

    public String getStaticPreview(Addition addition, PreviewData previewData) throws IOException, URISyntaxException {
        var dcParams = new DCParams(previewData, addition.getData(), false);
        var videoPreset = presetsService.getPreset(addition.getPresetId());
        return initStaticPreview(addition, dcParams, videoPreset).makeStaticTemplate();
    }

}
