package ru.yandex.canvas.service.video;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.canvas.model.video.StockAddition;
import ru.yandex.canvas.repository.video.StockVideoAdditionsRepository;
import ru.yandex.canvas.service.OnCreativeService;

public class StockVideoAdditionService implements OnCreativeService<StockAddition> {
    private final StockVideoAdditionsRepository repository;

    public StockVideoAdditionService(StockVideoAdditionsRepository repository) {
        this.repository = repository;
    }

    @Override
    public List<Long> filterPresent(List<Long> stockCreativeIds) {
        return repository.getStockAdditionsByCreativeIds(stockCreativeIds).stream()
                .map(StockAddition::getCreativeId)
                .collect(Collectors.toList());
    }

    @Override
    public Class<StockAddition> worksOn() {
        return StockAddition.class;
    }

    @Override
    public List<StockAddition> fetchByIds(List<Long> stockCreativeIds) {
        return repository.getStockAdditionsByCreativeIds(stockCreativeIds);
    }

    @Override
    public Map<Long, List<StockAddition>> fetchForTypeByIdsGroupedByClient(List<Long> creativeIds) {
        throw new UnsupportedOperationException("Stock additions doesn't belong to clients, use their normal " +
                "VideoAdditions counterparts which built on top of stock one");
    }
}
