package ru.yandex.canvas.service.video;

import java.io.IOException;
import java.util.Date;

import ru.yandex.canvas.model.stillage.StillageFileInfo;
import ru.yandex.canvas.model.video.CleanupOldConversionsResult;
import ru.yandex.canvas.model.video.VideoFiles;
import ru.yandex.canvas.model.video.files.FileStatus;
import ru.yandex.canvas.service.SandBoxService;

public interface VideoFileUploadServiceInterface {

    VideoFiles upload(VideoFiles record, StillageFileInfo info, Long presetId);

    Long startSandboxConverting(VideoFiles file, boolean needFast);

    void stopSandboxConverting(String fileId);

    FileStatus updateConvertingFile(String fileId, SandBoxService.SandboxConversionTaskOutput output)
            throws IOException;

    CleanupOldConversionsResult cleanupOldConversions(Date from, Date to);

    VideoFiles.VideoThumbnail getThumbnailFromUrl(String url);
}
