package ru.yandex.canvas.service.video;

import java.io.IOException;
import java.net.URI;

import org.springframework.data.domain.Sort;

import ru.yandex.canvas.model.stillage.StillageFileInfo;
import ru.yandex.canvas.model.video.VideoFiles;
import ru.yandex.canvas.repository.ItemsWithTotal;

public interface VideoFilesServiceInterface<T, M> {
    M markFileUsed(T file, Long clientId);

    T upload(byte[] content, String filename, Long clientId, VideoCreativeType videoCreativeType,
             Long presetId) throws IOException;

    T upload(URI url, String filename, Long clientId, VideoCreativeType videoCreativeType,
             Long presetId) throws IOException;

    T upload(StillageFileInfo info, String filename, Long clientId, VideoCreativeType videoCreativeType, Long presetId);

    StillageFileInfo processFileInfo(StillageFileInfo info, String filename, VideoCreativeType videoCreativeType);

    boolean delete(T file, Long clientId);

    T makeFromDb(VideoFiles record);

    ItemsWithTotal<T> getUserFiles(Long clientId, String nameSubstring, Sort.Direction direction, int limit, int offset,
                                   VideoCreativeType videoCreativeType, Long presetId, Boolean showFeeds);
}
