package ru.yandex.canvas.service.video;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class VideoFuzzySearchService {

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public static class VideoRangeRequest {
        private String query;
        private List<String> stillageIds;
        private Integer limit;
        private Integer offset;

        public Integer getLimit() {
            return limit;
        }

        public VideoRangeRequest setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Integer getOffset() {
            return offset;
        }

        public VideoRangeRequest setOffset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public String getQuery() {
            return query;
        }

        public VideoRangeRequest setQuery(String query) {
            this.query = query;
            return this;
        }

        public List<String> getStillageIds() {
            return stillageIds;
        }

        public VideoRangeRequest setStillageIds(List<String> stillageIds) {
            this.stillageIds = stillageIds;
            return this;
        }
    }

    private RestTemplate restTemplate;
    private String pythonBackend;

    public VideoFuzzySearchService(RestTemplate restTemplate, String pythonBackend) {
        this.restTemplate = restTemplate;
        this.pythonBackend = pythonBackend;
    }

    public List<String> rangeFiles(String query, List<String> stillageIds, Integer limit, Integer offset) {
        ParameterizedTypeReference<List<String>> typeReference =
                new ParameterizedTypeReference<List<String>>() {
                };

        VideoRangeRequest videoRangeRequest = new VideoRangeRequest()
                .setQuery(query)
                .setStillageIds(stillageIds)
                .setLimit(limit)
                .setOffset(offset);

        MultiValueMap<String, String> headers = new LinkedMultiValueMap<>();
        headers.add(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);

        return restTemplate
                .exchange(pythonBackend + "/files/range_by_query", HttpMethod.POST,
                        new HttpEntity<>(videoRangeRequest, headers), typeReference).getBody();
    }

}
