package ru.yandex.canvas.service.video;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class VideoMetaData {
    Long bitrate;
    Double duration;
    List<VideoStreamInfo> videoStreams;
    List<AudioStreamInfo> audioStreams;

    public Long getBitrate() {
        return bitrate;
    }

    public VideoMetaData setBitrate(Long bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    public Double getDuration() {
        return duration;
    }

    public VideoMetaData setDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    public List<VideoStreamInfo> getVideoStreams() {
        return videoStreams;
    }

    public VideoMetaData setVideoStreams(
            List<VideoStreamInfo> videoStreams) {
        this.videoStreams = videoStreams;
        return this;
    }

    public List<AudioStreamInfo> getAudioStreams() {
        return audioStreams;
    }

    public VideoMetaData setAudioStreams(List<AudioStreamInfo> sudioStreams) {
        this.audioStreams = sudioStreams;
        return this;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class AudioStreamInfo {
        AudioStreamInfo.BaseInfo baseInfo;

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static class BaseInfo {
            Integer index;
            Integer channelCount;
            String channelLayout;
            String sampleFormat;
            String codec;
            Double duration;
            Long sampleRate;
            Long bitrate;

            public Integer getIndex() {
                return index;
            }

            public AudioStreamInfo.BaseInfo setIndex(Integer index) {
                this.index = index;
                return this;
            }

            public Integer getChannelCount() {
                return channelCount;
            }

            public AudioStreamInfo.BaseInfo setChannelCount(Integer channelCount) {
                this.channelCount = channelCount;
                return this;
            }

            public String getChannelLayout() {
                return channelLayout;
            }

            public AudioStreamInfo.BaseInfo setChannelLayout(String channelLayout) {
                this.channelLayout = channelLayout;
                return this;
            }

            public String getSampleFormat() {
                return sampleFormat;
            }

            public AudioStreamInfo.BaseInfo setSampleFormat(String sampleFormat) {
                this.sampleFormat = sampleFormat;
                return this;
            }

            public String getCodec() {
                return codec;
            }

            public AudioStreamInfo.BaseInfo setCodec(String codec) {
                this.codec = codec;
                return this;
            }

            public Double getDuration() {
                return duration;
            }

            public AudioStreamInfo.BaseInfo setDuration(Double duration) {
                this.duration = duration;
                return this;
            }

            public Long getSampleRate() {
                return sampleRate;
            }

            public AudioStreamInfo.BaseInfo setSampleRate(Long sampleRate) {
                this.sampleRate = sampleRate;
                return this;
            }

            public Long getBitrate() {
                return bitrate;
            }

            public AudioStreamInfo.BaseInfo setBitrate(Long bitrate) {
                this.bitrate = bitrate;
                return this;
            }
        }

        public AudioStreamInfo.BaseInfo getBaseInfo() {
            return baseInfo;
        }

        public AudioStreamInfo setBaseInfo(
                AudioStreamInfo.BaseInfo baseInfo) {
            this.baseInfo = baseInfo;
            return this;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class VideoStreamInfo {
        private String profile;
        private Integer index;
        private String level;
        private String colorSpace;
        private Integer frameRate;
        private Integer height;
        private Integer width;
        private String pixelFormat;
        private String codec;
        private Double duration;
        private Integer bitrate;
        private String colorRange;

        public String getProfile() {
            return profile;
        }

        public Integer getIndex() {
            return index;
        }

        public String getLevel() {
            return level;
        }

        public String getColorSpace() {
            return colorSpace;
        }

        public Integer getFrameRate() {
            return frameRate;
        }

        public Integer getHeight() {
            return height;
        }

        public Integer getWidth() {
            return width;
        }

        public String getPixelFormat() {
            return pixelFormat;
        }

        public String getCodec() {
            return codec;
        }

        public Double getDuration() {
            return duration;
        }

        public VideoStreamInfo setDuration(Double duration) {
            this.duration = duration;
            return this;
        }

        public Integer getBitrate() {
            return bitrate;
        }

        public String getColorRange() {
            return colorRange;
        }
    }
}
