package ru.yandex.canvas.service.video;

import java.net.URI;

import org.springframework.web.util.UriComponentsBuilder;

import ru.yandex.canvas.model.video.Addition;
import ru.yandex.canvas.service.DirectService;
import ru.yandex.canvas.service.video.overlay.OverlayService;

import static ru.yandex.canvas.VideoConstants.NEW_LIVE_PREVIEW_URL_FOR_VIDEO_CREATIVES_ENABLED_FEATURE;
import static ru.yandex.canvas.VideoConstants.NEW_SCREENSHOT_URL_FOR_VIDEO_CREATIVES_ENABLED_FEATURE;

public class VideoPreviewUrlBuilder {
    private final DirectService directService;
    private final String canvasPreviewHost;
    private final URI webUri;

    public VideoPreviewUrlBuilder(DirectService directService, String canvasPreviewHost, String webUrl) {
        this.canvasPreviewHost = canvasPreviewHost;
        this.directService = directService;
        this.webUri = URI.create(webUrl);
    }


    public String getPreviewUrl(long clientId, Addition addition, Boolean isCompact) {
        if (addition.isOverlayAddition()) {
            return OverlayService.OVERLAY_PREVIEW_URL;
        }

        boolean isNewLivePreviewUrl = directService.getFeatures(clientId, null)
                .contains(NEW_LIVE_PREVIEW_URL_FOR_VIDEO_CREATIVES_ENABLED_FEATURE);

        UriComponentsBuilder uriBuilder = UriComponentsBuilder.newInstance();

        if (isNewLivePreviewUrl) {
            uriBuilder.uri(webUri).pathSegment("creative-preview", "video", addition.getId());
        } else {
            uriBuilder.scheme("https").host(canvasPreviewHost)
                    .pathSegment("video-additions", addition.getId(), "preview");
        }

        if (isCompact) {
            uriBuilder.queryParam("compact", "1");
        }

        return uriBuilder.build().toString();
    }

    public String buildScreenshotUrl(long clientId, Long creativeId) {
        boolean isNewScreenshotUrl = directService.getFeatures(clientId, null)
                .contains(NEW_SCREENSHOT_URL_FOR_VIDEO_CREATIVES_ENABLED_FEATURE);

        UriComponentsBuilder screenshotUrl = UriComponentsBuilder.newInstance();
        if (isNewScreenshotUrl) {
            screenshotUrl.uri(webUri)
                    .pathSegment("canvas-api", "video", "creatives", "getScreenshot", creativeId.toString());
        } else {
            screenshotUrl.scheme("https").host(canvasPreviewHost)
                    .pathSegment("rest", "video", "creatives", creativeId.toString(), "getScreenshot");
        }

        return screenshotUrl.build().toString();
    }
}
