package ru.yandex.canvas.service.video.files;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class MergedFileRecord {
    @JsonProperty("conversion_task_id")
    private Long conversionTaskId;

    @JsonProperty("formats")
    private List<FormatDescription> formatsList;

    @JsonProperty("stillage_id")
    private String id;

    @JsonProperty("stillage_url")
    private String stillageUrl;

    @JsonProperty("strm_prefix")
    private String strmPrefix;

    @JsonProperty("thumbnail")
    private ThumbnailDescription thumbnail;

    @JsonProperty("video")
    private VideoDescription video;

    @JsonProperty("audio")
    private AudioDescription audio;

    public static class ThumbnailDescription {
        private String url;
        private Long width;
        private Long height;
        private ThumbnailPreviewDescription preview;

        public String getUrl() {
            return url;
        }

        public ThumbnailDescription setUrl(String url) {
            this.url = url;
            return this;
        }

        public Long getWidth() {
            return width;
        }

        public ThumbnailDescription setWidth(Long width) {
            this.width = width;
            return this;
        }

        public Long getHeight() {
            return height;
        }

        public ThumbnailDescription setHeight(Long height) {
            this.height = height;
            return this;
        }

        public ThumbnailPreviewDescription getPreview() {
            return preview;
        }

        public ThumbnailDescription setPreview(ThumbnailPreviewDescription preview) {
            this.preview = preview;
            return this;
        }

        public static class ThumbnailPreviewDescription {
            private String url;
            private Long width;
            private Long height;

            public String getUrl() {
                return url;
            }

            public ThumbnailPreviewDescription setUrl(String url) {
                this.url = url;
                return this;
            }

            public Long getWidth() {
                return width;
            }

            public ThumbnailPreviewDescription setWidth(Long width) {
                this.width = width;
                return this;
            }

            public Long getHeight() {
                return height;
            }

            public ThumbnailPreviewDescription setHeight(Long height) {
                this.height = height;
                return this;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class FormatDescription {
        private String delivery;

        private String width;

        private String url;

        @JsonProperty("type")
        private String mimeType;

        private Long bitrate;

        private String id;

        private String height;

        public String getDelivery() {
            return delivery;
        }

        public FormatDescription setDelivery(String delivery) {
            this.delivery = delivery;
            return this;
        }

        public String getWidth() {
            return width;
        }

        public FormatDescription setWidth(String width) {
            this.width = width;
            return this;
        }

        public String getUrl() {
            return url;
        }

        public FormatDescription setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getMimeType() {
            return mimeType;
        }

        public FormatDescription setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Long getBitrate() {
            return bitrate;
        }

        public FormatDescription setBitrate(Long bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public String getId() {
            return id;
        }

        public FormatDescription setId(String id) {
            this.id = id;
            return this;
        }

        public String getHeight() {
            return height;
        }

        public FormatDescription setHeight(String height) {
            this.height = height;
            return this;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class VideoDescription {
        @JsonProperty("category_id")
        private Long categoryId;

        @JsonProperty("overlay_color")
        private String overlayColor;

        @JsonProperty("source_id")
        private String sourceId;

        @JsonProperty("source_name")
        private String sourceName;

        @JsonProperty("source_url")
        private String sourceUrl;

        @JsonProperty("stillage_id")
        private String stillageId;

        @JsonProperty("stillage_url")
        private String stillageUrl;

        @JsonProperty("order")
        private Long interfaceOrder;

        public Long getInterfaceOrder() {
            return interfaceOrder;
        }

        public void setInterfaceOrder(Long interfaceOrder) {
            this.interfaceOrder = interfaceOrder;
        }

        public Long getCategoryId() {
            return categoryId;
        }

        public VideoDescription setCategoryId(Long categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public String getOverlayColor() {
            return overlayColor;
        }

        public VideoDescription setOverlayColor(String overlayColor) {
            this.overlayColor = overlayColor;
            return this;
        }

        public String getSourceId() {
            return sourceId;
        }

        public VideoDescription setSourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public String getSourceName() {
            return sourceName;
        }

        public VideoDescription setSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public String getSourceUrl() {
            return sourceUrl;
        }

        public VideoDescription setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        public String getStillageId() {
            return stillageId;
        }

        public VideoDescription setStillageId(String stillageId) {
            this.stillageId = stillageId;
            return this;
        }

        public String getStillageUrl() {
            return stillageUrl;
        }

        public VideoDescription setStillageUrl(String stillageUrl) {
            this.stillageUrl = stillageUrl;
            return this;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class AudioDescription {
        @JsonProperty("duration")
        private Long duration;

        @JsonProperty("name")
        private String name;

        @JsonProperty("stillage_id")
        private String stillageId;

        @JsonProperty("stillage_url")
        private String stillageUrl;

        @JsonProperty("order")
        private Long interfaceOrder;

        public Long getInterfaceOrder() {
            return interfaceOrder;
        }

        public void setInterfaceOrder(Long interfaceOrder) {
            this.interfaceOrder = interfaceOrder;
        }

        public Long getDuration() {
            return duration;
        }

        public AudioDescription setDuration(Long duration) {
            this.duration = duration;
            return this;
        }

        public String getName() {
            return name;
        }

        public AudioDescription setName(String name) {
            this.name = name;
            return this;
        }

        public String getStillageId() {
            return stillageId;
        }

        public AudioDescription setStillageId(String stillageId) {
            this.stillageId = stillageId;
            return this;
        }

        public String getStillageUrl() {
            return stillageUrl;
        }

        public AudioDescription setStillageUrl(String stillageUrl) {
            this.stillageUrl = stillageUrl;
            return this;
        }
    }

    public Long getConversionTaskId() {
        return conversionTaskId;
    }

    public MergedFileRecord setConversionTaskId(Long conversionTaskId) {
        this.conversionTaskId = conversionTaskId;
        return this;
    }

    public List<FormatDescription> getFormatsList() {
        return formatsList;
    }

    public MergedFileRecord setFormatsList(
            List<FormatDescription> formatsList) {
        this.formatsList = formatsList;
        return this;
    }

    public String getId() {
        return id;
    }

    public MergedFileRecord setId(String id) {
        this.id = id;
        return this;
    }

    public String getStillageUrl() {
        return stillageUrl;
    }

    public MergedFileRecord setStillageUrl(String stillageUrl) {
        this.stillageUrl = stillageUrl;
        return this;
    }

    public String getStrmPrefix() {
        return strmPrefix;
    }

    public MergedFileRecord setStrmPrefix(String strmPrefix) {
        this.strmPrefix = strmPrefix;
        return this;
    }

    public ThumbnailDescription getThumbnail() {
        return thumbnail;
    }

    public MergedFileRecord setThumbnail(
            ThumbnailDescription thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public VideoDescription getVideo() {
        return video;
    }

    public MergedFileRecord setVideo(VideoDescription video) {
        this.video = video;
        return this;
    }

    public AudioDescription getAudio() {
        return audio;
    }

    public MergedFileRecord setAudio(AudioDescription audio) {
        this.audio = audio;
        return this;
    }
}
