package ru.yandex.canvas.service.video.files;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

public class VideoCategoriesService {
    private static final String FILE_PATH = "/video_stock/categories.json";

    private Map<Long, CategoriesRecord> categoriesRecordMap;

    public VideoCategoriesService() throws IOException {
        categoriesRecordMap = new LinkedHashMap<>();
        ObjectMapper objectMapper = new ObjectMapper();
        InputStream inputStream = getClass().getResourceAsStream(FILE_PATH);
        TypeReference<CategoriesRecord> typeReference = new TypeReference<CategoriesRecord>() {
        };

        Iterator<CategoriesRecord> iterator = objectMapper.readerFor(typeReference).readValues(inputStream);

        while (iterator.hasNext()) {
            CategoriesRecord categoriesRecord = iterator.next();
            categoriesRecordMap.put(categoriesRecord.getId(), categoriesRecord);
        }

        categoriesRecordMap = Collections.unmodifiableMap(categoriesRecordMap);
    }

    public Map<Long, CategoriesRecord> getCategoriesMap() {
        return categoriesRecordMap;
    }
}
