package ru.yandex.canvas.service.video.generation;

import ru.yandex.canvas.model.video.addition.AdditionElement;
import ru.yandex.canvas.model.video.addition.Options;
import ru.yandex.canvas.model.video.addition.options.AdditionElementOptions;
import ru.yandex.canvas.service.video.CreativesGenerationService;
import ru.yandex.canvas.service.video.presets.elements.BaseElementOptions;

public enum AdditionFactory implements BaseFactory {
    INSTANCE;

    @Override
    public AdditionElement.ElementType getType() {
        return AdditionElement.ElementType.ADDITION;
    }

    @Override
    public Options getOptionsInstance() {
        return new AdditionElementOptions();
    }

    @Override
    public void copyOptions(BaseElementOptions elementOptions, Options options,
                            CreativesGenerationService.ConditionsCombination combination) {

        AdditionElementOptions additionElementOptions = (AdditionElementOptions) options;
        additionElementOptions.setVideoId(combination.getVideo());
        additionElementOptions.setAudioId(combination.getAudio());
    }

}
