package ru.yandex.canvas.service.video.generation;

import ru.yandex.canvas.model.video.addition.AdditionElement;
import ru.yandex.canvas.model.video.addition.Options;
import ru.yandex.canvas.service.video.CreativesGenerationService;
import ru.yandex.canvas.service.video.presets.elements.BaseElementOptions;
import ru.yandex.canvas.service.video.presets.elements.ElementButtonOptions;
import ru.yandex.canvas.service.video.presets.elements.ElementTextOptions;
import ru.yandex.canvas.service.video.presets.elements.PresetElement;

public interface BaseFactory {

    AdditionElement.ElementType getType();

    Options getOptionsInstance();

    default AdditionElement convert(PresetElement element,
                                    CreativesGenerationService.ConditionsCombination combination) {
        if (!element.getAvailable()) {
            return null;
        }

        AdditionElement additionElement = new AdditionElement(getType());
        additionElement.withAvailable(true);

        Options options = getOptionsInstance();
        copyOptions(element.getOptions(), options, combination);
        additionElement.withOptions(options);

        return additionElement;
    }

    default void copyOptions(BaseElementOptions elementOptions, Options additionElementOptions,
                             CreativesGenerationService.ConditionsCombination combination) {
        _copyOptions(elementOptions, additionElementOptions, combination);
    }

    default void _copyOptions(BaseElementOptions elementOptions, Options additionElementOptions,
                              CreativesGenerationService.ConditionsCombination combination) {

        if (elementOptions instanceof ElementTextOptions) {
            ElementTextOptions textOptions = (ElementTextOptions) elementOptions;

            additionElementOptions.setText(textOptions.getText())
                    .setTextColor(textOptions.getTextColor())
                    .setBackgroundColor(textOptions.getBackgroundColor())
                    .setPlaceholder(textOptions.getPlaceholder());
        }

        if (elementOptions instanceof ElementButtonOptions) {
            ElementButtonOptions buttonOptions = (ElementButtonOptions) elementOptions;

            additionElementOptions.setBorderColor(buttonOptions.getBorderColor());
            additionElementOptions.setColor(buttonOptions.getColor());
        }

    }

}
