package ru.yandex.canvas.service.video.generation;

import ru.yandex.canvas.model.video.addition.AdditionElement;
import ru.yandex.canvas.model.video.addition.Options;
import ru.yandex.canvas.model.video.addition.options.ButtonElementOptions;
import ru.yandex.canvas.service.TankerKeySet;
import ru.yandex.canvas.service.video.CreativesGenerationService;
import ru.yandex.canvas.service.video.presets.elements.BaseElementOptions;

public enum ButtonFactory implements BaseFactory {
    INSTANCE;

    @Override
    public AdditionElement.ElementType getType() {
        return AdditionElement.ElementType.BUTTON;
    }

    @Override
    public Options getOptionsInstance() {
        return new ButtonElementOptions();
    }


    @Override
    public void copyOptions(BaseElementOptions elementOptions, Options additionElementOptions,
                            CreativesGenerationService.ConditionsCombination combination) {
        _copyOptions(elementOptions, additionElementOptions, combination);

        if (combination.getPreset().getDescription().getButtonTextPresent()) {
            additionElementOptions.setText(TankerKeySet.VIDEO.key("autogenerated-addition-button-text"));
            additionElementOptions.setPlaceholder(TankerKeySet.VIDEO.key("button_text_placeholder"));
        }

    }
}
