package ru.yandex.canvas.service.video.generation;

import ru.yandex.canvas.model.video.addition.AdditionElement;
import ru.yandex.canvas.model.video.addition.Options;
import ru.yandex.canvas.model.video.addition.options.DomainElementOptions;
import ru.yandex.canvas.service.TankerKeySet;
import ru.yandex.canvas.service.video.CreativesGenerationService;
import ru.yandex.canvas.service.video.presets.elements.BaseElementOptions;

public enum DomainFactory implements BaseFactory {
    INSTANCE;

    @Override
    public AdditionElement.ElementType getType() {
        return AdditionElement.ElementType.DOMAIN;
    }

    @Override
    public Options getOptionsInstance() {
        return new DomainElementOptions();
    }

    //getDomainEditable
    @Override
    public void copyOptions(BaseElementOptions elementOptions, Options additionElementOptions,
                            CreativesGenerationService.ConditionsCombination combination) {
        _copyOptions(elementOptions, additionElementOptions, combination);

        if (combination.getPreset().getDescription().getDomainEditable()) {
            additionElementOptions.setPlaceholder(TankerKeySet.VIDEO.key("domain_placeholder"));
        }

    }

}
