package ru.yandex.canvas.service.video.generation;

import ru.yandex.canvas.model.video.addition.AdditionElement;
import ru.yandex.canvas.model.video.addition.Options;
import ru.yandex.canvas.model.video.addition.options.LegalElementOptions;
import ru.yandex.canvas.service.TankerKeySet;
import ru.yandex.canvas.service.video.CreativesGenerationService;
import ru.yandex.canvas.service.video.presets.elements.BaseElementOptions;

public enum LegalFactory implements BaseFactory {
    INSTANCE;

    @Override
    public AdditionElement.ElementType getType() {
        return AdditionElement.ElementType.LEGAL;
    }

    @Override
    public Options getOptionsInstance() {
        return new LegalElementOptions();
    }

    @Override
    public void copyOptions(BaseElementOptions elementOptions, Options additionElementOptions,
                            CreativesGenerationService.ConditionsCombination combination) {
        _copyOptions(elementOptions, additionElementOptions, combination);
        additionElementOptions.setPlaceholder(TankerKeySet.VIDEO.key("opf_text_placeholder"));
    }

}
