package ru.yandex.canvas.service.video.generation;

import java.util.ArrayList;

import com.google.common.collect.ImmutableMap;

import ru.yandex.canvas.model.video.addition.AdditionData;
import ru.yandex.canvas.model.video.addition.AdditionDataBundle;
import ru.yandex.canvas.model.video.addition.AdditionElement;
import ru.yandex.canvas.service.video.CreativesGenerationService;
import ru.yandex.canvas.service.video.presets.VideoPreset;
import ru.yandex.canvas.service.video.presets.elements.PresetElement;
import ru.yandex.canvas.service.video.presets.elements.PresetElementType;

import static ru.yandex.canvas.service.video.presets.elements.PresetElementType.ADDITION;
import static ru.yandex.canvas.service.video.presets.elements.PresetElementType.AGE;
import static ru.yandex.canvas.service.video.presets.elements.PresetElementType.BODY;
import static ru.yandex.canvas.service.video.presets.elements.PresetElementType.BUTTON;
import static ru.yandex.canvas.service.video.presets.elements.PresetElementType.DISCLAIMER;
import static ru.yandex.canvas.service.video.presets.elements.PresetElementType.LEGAL;
import static ru.yandex.canvas.service.video.presets.elements.PresetElementType.SUBTITLES;
import static ru.yandex.canvas.service.video.presets.elements.PresetElementType.TITLE;

public class StockElementFactory {
    private static final ImmutableMap<PresetElementType, BaseFactory> map =
            ImmutableMap.<PresetElementType, BaseFactory>builder()
                    .put(ADDITION, AdditionFactory.INSTANCE)
                    .put(TITLE, TitleFactory.INSTANCE)
                    .put(BODY, BodyFactory.INSTANCE)
                    .put(PresetElementType.DOMAIN, DomainFactory.INSTANCE)
                    .put(BUTTON, ButtonFactory.INSTANCE)
                    .put(DISCLAIMER, DisclaimerFactory.INSTANCE)
                    .put(AGE, AgeFactory.INSTANCE)
                    .put(LEGAL, LegalFactory.INSTANCE)
                    .put(SUBTITLES, SubtitlesFactory.INSTANCE).build();

    public static AdditionData convert(VideoPreset preset,
                                       CreativesGenerationService.ConditionsCombination combination) {
        AdditionData additionData = new AdditionData();
        additionData.setBundle(new AdditionDataBundle().setName(preset.getBundleName()));
        additionData.setElements(new ArrayList<>());

        for (PresetElement element : preset.getPresetElementList()) {

            if (!map.containsKey(element.getType())) {
                throw new IllegalArgumentException("Unknown preset element " + element.getType());
            }

            AdditionElement additionElement = map.get(element.getType()).convert(element, combination);

            if (additionElement == null)
                continue;

            additionData.getElements().add(additionElement);
        }

        return additionData;
    }

}
