package ru.yandex.canvas.service.video.generation;

import ru.yandex.canvas.model.video.addition.AdditionElement;
import ru.yandex.canvas.model.video.addition.Options;
import ru.yandex.canvas.model.video.addition.options.TitleElementOptions;
import ru.yandex.canvas.service.video.CreativesGenerationService;
import ru.yandex.canvas.service.video.presets.elements.BaseElementOptions;

public enum TitleFactory implements BaseFactory {
    INSTANCE;

    @Override
    public AdditionElement.ElementType getType() {
        return AdditionElement.ElementType.TITLE;
    }

    @Override
    public Options getOptionsInstance() {
        return new TitleElementOptions();
    }

    @Override
    public void copyOptions(BaseElementOptions elementOptions, Options additionElementOptions,
                            CreativesGenerationService.ConditionsCombination combination) {
        _copyOptions(elementOptions, additionElementOptions, combination);

        if (combination.getPreset().getDescription().getTitleBackgoundColor()
                .equals("XXX")) //TODO it should be a separated option, not sort of a value
        {
            //TODO!!
            additionElementOptions.setBackgroundColor(combination.getMovie().getVideoSource().getOverlayColor());
        }

    }

}
